# Cut and paste
import pygame
import math

def distance(a, b):
    r = (a[0]-b[0])*(a[0]-b[0]) + (a[1]-b[1])*(a[1]-b[1])
    return math.sqrt(r)

def draw():
    screen.fill(WHITE)
    if len(points) < 1:
        return
    p0 = points[0]
    for p in points:
        pygame.draw.line(screen, BLACK, p0, p, 2)
        p0 = p
    if not done:
        pygame.draw.line(screen, BLACK, p0, (mouseX, mouseY), 2)


screen = pygame.display.set_mode((1100, 900))  # Notice the tuple! It's not 2 arguments.
clock = pygame.time.Clock()
pygame.font.init()
myfont = pygame.font.SysFont('Times Roman', 30)
xsurface = myfont.render('X', False, (0, 0, 0))
ysurface = myfont.render("Y", False, (0, 0, 0))
FPS = 60              # This variable will define how many frames we update per second.
BLACK = (0, 0, 0)
WHITE = (255, 255, 255)
points = []
currentColor = (0, 0, 0)
done = False
while True:
    clock.tick(FPS)
    mouseX, mouseY = pygame.mouse.get_pos()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            quit()
        if event.type == pygame.MOUSEBUTTONDOWN:
            pass
        if event.type == pygame.MOUSEBUTTONUP:     # Mouse button was released
            if done:
                continue
            points.append([mouseX, mouseY])
            if distance((mouseX,mouseY), points[0])< 3 and len(points)>2:
                points[-1] = points[0]
                done = True
    draw()
    pygame.display.update()  # redraw the screen
